/*
 * Decompiled with CFR 0.152.
 */
class d {
    static final int[] GOOD_LENGTH = new int[]{0, 4, 4, 4, 4, 8, 8, 8, 32, 32};
    static final int[] MAX_LAZY = new int[]{0, 4, 5, 6, 4, 16, 16, 32, 128, 258};
    static final int[] NICE_LENGTH = new int[]{0, 8, 16, 32, 16, 32, 128, 128, 258, 258};
    static final int[] MAX_CHAIN = new int[]{0, 4, 8, 32, 16, 32, 128, 256, 1024, 4096};
    static final int[] COMPR_FUNC = new int[]{0, 1, 1, 1, 1, 2, 2, 2, 2, 2};
    private byte[] window;
    private byte[] inputBuf;
    private short[] head;
    private short[] prev;
    private int ins_h;
    private int matchStart;
    private int matchLen;
    private boolean prevAvailable;
    private int blockStart;
    private int strstart;
    private int lookahead;
    private int strategy;
    private int max_chain;
    private int max_lazy;
    private int niceLength;
    private int goodLength;
    private int comprFunc;
    private int inputOff;
    private int inputEnd;
    private m pending;
    private e huffman;
    private a adler;

    d(m m2) {
        this.pending = m2;
        this.huffman = new e(this.pending);
        this.adler = new a();
        this.window = new byte[65536];
        this.head = new short[32768];
        this.prev = new short[32768];
        this.strstart = 1;
        this.blockStart = 1;
    }

    public void reset() {
        this.strstart = 1;
        this.blockStart = 1;
        this.lookahead = 0;
        this.prevAvailable = false;
        this.matchLen = 2;
        for (int i2 = Short.MAX_VALUE; i2 >= 0; --i2) {
            this.head[i2] = 0;
            this.prev[i2] = 0;
        }
        this.huffman.reset();
        this.adler.reset();
    }

    public void resetAdler() {
        this.adler.reset();
    }

    public int getAdler() {
        return this.adler.checksum;
    }

    public void setStrategy(int n2) {
        this.strategy = n2;
    }

    public void setLevel(int n2) {
        this.goodLength = GOOD_LENGTH[n2];
        this.max_lazy = MAX_LAZY[n2];
        this.niceLength = NICE_LENGTH[n2];
        this.max_chain = MAX_CHAIN[n2];
        if (COMPR_FUNC[n2] != this.comprFunc) {
            switch (this.comprFunc) {
                case 0: {
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushStoredBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.updateHash();
                    break;
                }
                case 1: {
                    if (this.strstart <= this.blockStart) break;
                    this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                    this.blockStart = this.strstart;
                    break;
                }
                case 2: {
                    if (this.prevAvailable) {
                        this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                    }
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.prevAvailable = false;
                    this.matchLen = 2;
                }
            }
            this.comprFunc = COMPR_FUNC[n2];
        }
    }

    private void updateHash() {
        this.ins_h = this.window[this.strstart] << 5 ^ this.window[this.strstart + 1];
    }

    private int insertString() {
        short s2;
        int n2 = (this.ins_h << 5 ^ this.window[this.strstart + 2]) & Short.MAX_VALUE;
        this.prev[this.strstart & Short.MAX_VALUE] = s2 = this.head[n2];
        this.head[n2] = (short)this.strstart;
        this.ins_h = n2;
        return s2 & 0xFFFF;
    }

    private void slideWindow() {
        System.arraycopy(this.window, 32768, this.window, 0, 32768);
        this.matchStart -= 32768;
        this.strstart -= 32768;
        this.blockStart -= 32768;
        for (int i2 = 0; i2 < 32768; ++i2) {
            int n2 = this.head[i2] & 0xFFFF;
            this.head[i2] = n2 >= 32768 ? (short)(n2 - 32768) : (short)0;
            n2 = this.prev[i2] & 0xFFFF;
            this.prev[i2] = n2 >= 32768 ? (short)(n2 - 32768) : (short)0;
        }
    }

    private void fillWindow() {
        if (this.strstart >= 65274) {
            this.slideWindow();
        }
        while (this.lookahead < 262 && this.inputOff < this.inputEnd) {
            int n2 = Math.min(65536 - this.lookahead - this.strstart, this.inputEnd - this.inputOff);
            System.arraycopy(this.inputBuf, this.inputOff, this.window, this.strstart + this.lookahead, n2);
            this.adler.update(this.inputBuf, this.inputOff, n2);
            this.inputOff += n2;
            this.lookahead += n2;
        }
        if (this.lookahead > 2) {
            this.updateHash();
        }
    }

    private boolean findLongestMatch(int n2) {
        int n3 = this.max_chain;
        int n4 = this.niceLength;
        short[] sArray = this.prev;
        int n5 = this.strstart;
        int n6 = this.strstart + this.matchLen;
        int n7 = Math.max(this.matchLen, 2);
        int n8 = Math.max(this.strstart - 32506, 0);
        int n9 = n5 + 257;
        byte by = this.window[n6 - 1];
        byte by2 = this.window[n6];
        if (n7 >= this.goodLength) {
            n3 >>= 2;
        }
        if (n4 > this.lookahead) {
            n4 = this.lookahead;
        }
        do {
            if (this.window[n2 + n7] != by2 || this.window[n2 + n7 - 1] != by || this.window[n2] != this.window[n5] || this.window[n2 + 1] != this.window[n5 + 1]) continue;
            int n10 = n2 + 2;
            n5 += 2;
            while (this.window[++n5] == this.window[++n10] && this.window[++n5] == this.window[++n10] && this.window[++n5] == this.window[++n10] && this.window[++n5] == this.window[++n10] && this.window[++n5] == this.window[++n10] && this.window[++n5] == this.window[++n10] && this.window[++n5] == this.window[++n10] && this.window[++n5] == this.window[++n10] && n5 < n9) {
            }
            if (n5 > n6) {
                this.matchStart = n2;
                n6 = n5;
                n7 = n5 - this.strstart;
                if (n7 >= n4) break;
                by = this.window[n6 - 1];
                by2 = this.window[n6];
            }
            n5 = this.strstart;
        } while ((n2 = sArray[n2 & Short.MAX_VALUE] & 0xFFFF) > n8 && --n3 != 0);
        this.matchLen = Math.min(n7, this.lookahead);
        return this.matchLen >= 3;
    }

    private boolean deflateStored(boolean bl, boolean bl2) {
        if (!bl && this.lookahead == 0) {
            return false;
        }
        this.strstart += this.lookahead;
        this.lookahead = 0;
        int n2 = this.strstart - this.blockStart;
        if (n2 >= 65531 || this.blockStart < 32768 && n2 >= 32506 || bl) {
            boolean bl3 = bl2;
            if (n2 > 65531) {
                n2 = 65531;
                bl3 = false;
            }
            this.huffman.flushStoredBlock(this.window, this.blockStart, n2, bl3);
            this.blockStart += n2;
            return !bl3;
        }
        return true;
    }

    private boolean deflateFast(boolean bl, boolean bl2) {
        if (this.lookahead < 262 && !bl) {
            return false;
        }
        while (this.lookahead >= 262 || bl) {
            int n2;
            if (this.lookahead == 0) {
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, bl2);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart > 65274) {
                this.slideWindow();
            }
            if (this.lookahead >= 3 && (n2 = this.insertString()) != 0 && this.strategy != 2 && this.strstart - n2 <= 32506 && this.findLongestMatch(n2)) {
                this.huffman.tallyDist(this.strstart - this.matchStart, this.matchLen);
                this.lookahead -= this.matchLen;
                if (this.matchLen <= this.max_lazy && this.lookahead >= 3) {
                    while (--this.matchLen > 0) {
                        ++this.strstart;
                        this.insertString();
                    }
                    ++this.strstart;
                } else {
                    this.strstart += this.matchLen;
                    if (this.lookahead >= 2) {
                        this.updateHash();
                    }
                }
                this.matchLen = 2;
                continue;
            }
            this.huffman.tallyLit(this.window[this.strstart] & 0xFF);
            ++this.strstart;
            --this.lookahead;
            if (!this.huffman.isFull()) continue;
            boolean bl3 = bl2 && this.lookahead == 0;
            this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, bl3);
            this.blockStart = this.strstart;
            return !bl3;
        }
        return true;
    }

    private boolean deflateSlow(boolean bl, boolean bl2) {
        if (this.lookahead < 262 && !bl) {
            return false;
        }
        while (this.lookahead >= 262 || bl) {
            int n2;
            if (this.lookahead == 0) {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                }
                this.prevAvailable = false;
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, bl2);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart >= 65274) {
                this.slideWindow();
            }
            int n3 = this.matchStart;
            int n4 = this.matchLen;
            if (this.lookahead >= 3) {
                n2 = this.insertString();
                if (this.strategy != 2 && n2 != 0 && this.strstart - n2 <= 32506 && this.findLongestMatch(n2) && this.matchLen <= 5 && (this.strategy == 1 || this.matchLen == 3 && this.strstart - this.matchStart > 4096)) {
                    this.matchLen = 2;
                }
            }
            if (n4 >= 3 && this.matchLen <= n4) {
                this.huffman.tallyDist(this.strstart - 1 - n3, n4);
                n4 -= 2;
                do {
                    ++this.strstart;
                    --this.lookahead;
                    if (this.lookahead < 3) continue;
                    this.insertString();
                } while (--n4 > 0);
                ++this.strstart;
                --this.lookahead;
                this.prevAvailable = false;
                this.matchLen = 2;
            } else {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                }
                this.prevAvailable = true;
                ++this.strstart;
                --this.lookahead;
            }
            if (!this.huffman.isFull()) continue;
            n2 = this.strstart - this.blockStart;
            if (this.prevAvailable) {
                --n2;
            }
            boolean bl3 = bl2 && this.lookahead == 0 && !this.prevAvailable;
            this.huffman.flushBlock(this.window, this.blockStart, n2, bl3);
            this.blockStart += n2;
            return !bl3;
        }
        return true;
    }

    void setInput(byte[] byArray, int n2, int n3) {
        this.inputBuf = byArray;
        this.inputOff = n2;
        this.inputEnd = n2 + n3;
    }

    boolean needsInput() {
        return this.inputEnd == this.inputOff;
    }

    boolean deflate(boolean bl, boolean bl2) {
        boolean bl3 = false;
        do {
            this.fillWindow();
            boolean bl4 = bl && this.inputOff == this.inputEnd;
            switch (this.comprFunc) {
                case 0: {
                    bl3 = this.deflateStored(bl4, bl2);
                    break;
                }
                case 1: {
                    bl3 = this.deflateFast(bl4, bl2);
                    break;
                }
                case 2: {
                    bl3 = this.deflateSlow(bl4, bl2);
                }
            }
        } while (this.pending.isFlushed() && bl3);
        return bl3;
    }
}

