/*
 * Decompiled with CFR 0.152.
 */
public class h {
    private static final int[] CPLENS = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    private static final int[] CPLEXT = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
    private static final int[] CPDIST = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] CPDEXT = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private int mode;
    private int readAdler;
    private int neededBits;
    private int uncomprLen;
    private boolean isLastBlock;
    private int totalOut;
    private int totalIn;
    private int repLength;
    private int repDist;
    private boolean nowrap;
    private n input;
    private l outputWindow;
    private i dynHeader;
    private j litlenTree;
    private j distTree;
    private a adler;

    public h(boolean bl) {
        this.nowrap = bl;
        this.adler = new a();
        this.input = new n();
        this.outputWindow = new l();
        this.mode = this.nowrap ? 2 : 0;
    }

    public boolean finished() {
        return this.mode == 12 && this.outputWindow.getAvailable() == 0;
    }

    public int getRemaining() {
        return this.input.getAvailableBytes();
    }

    public int getTotalIn() {
        return this.totalIn - this.getRemaining();
    }

    public int getTotalOut() {
        return this.totalOut;
    }

    public int inflate(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return 0;
        }
        int n4 = 0;
        do {
            if (this.mode == 11) continue;
            int n5 = this.outputWindow.copyOutput(byArray, n2, n3);
            this.adler.update(byArray, n2, n5);
            n2 += n5;
            n4 += n5;
            this.totalOut += n5;
            if ((n3 -= n5) != 0) continue;
            return n4;
        } while (this.decode() || this.outputWindow.getAvailable() > 0 && this.mode != 11);
        return n4;
    }

    public boolean needsDictionary() {
        return this.mode == 1 && this.neededBits == 0;
    }

    public boolean needsInput() {
        return this.input.needsInput();
    }

    public void reset() {
        this.mode = this.nowrap ? 2 : 0;
        this.totalOut = 0;
        this.totalIn = 0;
        this.input.reset();
        this.outputWindow.reset();
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.isLastBlock = false;
        this.adler.reset();
    }

    public void setInput(byte[] byArray, int n2, int n3) {
        this.input.setInput(byArray, n2, n3);
        this.totalIn += n3;
    }

    private boolean decodeHeader() {
        int n2 = this.input.peekBits(16);
        if (n2 < 0) {
            return false;
        }
        this.input.dropBits(16);
        n2 = (n2 << 8 | n2 >> 8) & 0xFFFF;
        if ((n2 & 0x20) == 0) {
            this.mode = 2;
        } else {
            this.mode = 1;
            this.neededBits = 32;
        }
        return true;
    }

    private boolean decodeDict() {
        while (this.neededBits > 0) {
            int n2 = this.input.peekBits(8);
            if (n2 < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | n2;
            this.neededBits -= 8;
        }
        return false;
    }

    private boolean decodeHuffman() {
        int n2 = this.outputWindow.getFreeSpace();
        while (n2 >= 258) {
            switch (this.mode) {
                case 7: {
                    int n3;
                    while (((n3 = this.litlenTree.getSymbol(this.input)) & 0xFFFFFF00) == 0) {
                        this.outputWindow.write(n3);
                        if (--n2 >= 258) continue;
                        return true;
                    }
                    if (n3 < 257) {
                        if (n3 < 0) {
                            return false;
                        }
                        this.distTree = null;
                        this.litlenTree = null;
                        this.mode = 2;
                        return true;
                    }
                    this.repLength = CPLENS[n3 - 257];
                    this.neededBits = CPLEXT[n3 - 257];
                }
                case 8: {
                    int n4;
                    if (this.neededBits > 0) {
                        this.mode = 8;
                        n4 = this.input.peekBits(this.neededBits);
                        if (n4 < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repLength += n4;
                    }
                    this.mode = 9;
                }
                case 9: {
                    int n3 = this.distTree.getSymbol(this.input);
                    if (n3 < 0) {
                        return false;
                    }
                    this.repDist = CPDIST[n3];
                    this.neededBits = CPDEXT[n3];
                }
                case 10: {
                    int n4;
                    if (this.neededBits > 0) {
                        this.mode = 10;
                        n4 = this.input.peekBits(this.neededBits);
                        if (n4 < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repDist += n4;
                    }
                    this.outputWindow.repeat(this.repLength, this.repDist);
                    n2 -= this.repLength;
                    this.mode = 7;
                }
            }
        }
        return true;
    }

    private boolean decodeChksum() {
        while (this.neededBits > 0) {
            int n2 = this.input.peekBits(8);
            if (n2 < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | n2;
            this.neededBits -= 8;
        }
        this.mode = 12;
        return false;
    }

    private boolean decode() {
        switch (this.mode) {
            case 0: {
                return this.decodeHeader();
            }
            case 1: {
                return this.decodeDict();
            }
            case 11: {
                return this.decodeChksum();
            }
            case 2: {
                if (this.isLastBlock) {
                    if (this.nowrap) {
                        this.mode = 12;
                        return false;
                    }
                    this.input.skipToByteBoundary();
                    this.neededBits = 32;
                    this.mode = 11;
                    return true;
                }
                int n2 = this.input.peekBits(3);
                if (n2 < 0) {
                    return false;
                }
                this.input.dropBits(3);
                if ((n2 & 1) != 0) {
                    this.isLastBlock = true;
                }
                switch (n2 >> 1) {
                    case 0: {
                        this.input.skipToByteBoundary();
                        this.mode = 3;
                        break;
                    }
                    case 1: {
                        this.litlenTree = j.defLitLenTree;
                        this.distTree = j.defDistTree;
                        this.mode = 7;
                        break;
                    }
                    case 2: {
                        this.dynHeader = new i();
                        this.mode = 6;
                    }
                }
                return true;
            }
            case 3: {
                this.uncomprLen = this.input.peekBits(16);
                if (this.uncomprLen < 0) {
                    return false;
                }
                this.input.dropBits(16);
                this.mode = 4;
            }
            case 4: {
                int n3 = this.input.peekBits(16);
                if (n3 < 0) {
                    return false;
                }
                this.input.dropBits(16);
                this.mode = 5;
            }
            case 5: {
                int n3 = this.outputWindow.copyStored(this.input, this.uncomprLen);
                this.uncomprLen -= n3;
                if (this.uncomprLen == 0) {
                    this.mode = 2;
                    return true;
                }
                return !this.input.needsInput();
            }
            case 6: {
                if (!this.dynHeader.decode(this.input)) {
                    return false;
                }
                this.litlenTree = this.dynHeader.buildLitLenTree();
                this.distTree = this.dynHeader.buildDistTree();
                this.mode = 7;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.decodeHuffman();
            }
            case 12: {
                return false;
            }
        }
        return false;
    }
}

