/*
 * Decompiled with CFR 0.152.
 */
class m {
    private byte[] buf;
    private int start;
    private int end;
    private int bits;
    private int bitCount;

    public m(int n2) {
        this.buf = new byte[n2];
    }

    public void reset() {
        this.bits = 0;
        this.bitCount = 0;
        this.end = 0;
        this.start = 0;
    }

    public void writeShortMSB(int n2) {
        this.buf[this.end++] = (byte)(n2 >> 8);
        this.buf[this.end++] = (byte)n2;
    }

    public boolean isFlushed() {
        return this.end == 0;
    }

    public void writeShort(int n2) {
        this.buf[this.end++] = (byte)n2;
        this.buf[this.end++] = (byte)(n2 >> 8);
    }

    public final void writeBlock(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.buf, this.end, n3);
        this.end += n3;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public void alignToByte() {
        if (this.bitCount > 0) {
            this.buf[this.end++] = (byte)this.bits;
            if (this.bitCount > 8) {
                this.buf[this.end++] = (byte)(this.bits >> 8 & 0xFF);
            }
        }
        this.bits = 0;
        this.bitCount = 0;
    }

    public void writeBits(int n2, int n3) {
        this.bits |= n2 << this.bitCount;
        this.bitCount += n3;
        if (this.bitCount >= 16) {
            this.buf[this.end++] = (byte)this.bits;
            this.buf[this.end++] = (byte)(this.bits >> 8);
            this.bits = this.bits >> 16 & 0xFFFF;
            this.bitCount -= 16;
        }
    }

    public int flush(byte[] byArray, int n2, int n3) {
        if (this.bitCount >= 8) {
            this.buf[this.end++] = (byte)this.bits;
            this.bits = this.bits >> 8 & 0xFFFFFF;
            this.bitCount -= 8;
        }
        if (n3 > this.end - this.start) {
            n3 = this.end - this.start;
            System.arraycopy(this.buf, this.start, byArray, n2, n3);
            this.end = 0;
            this.start = 0;
        } else {
            System.arraycopy(this.buf, this.start, byArray, n2, n3);
            this.start += n3;
        }
        return n3;
    }
}

