/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.io.BitOutputStream;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.SongPattern;
import dinesh.mobile.sms.ringtone.SoundCommandSpecifier;
import java.io.IOException;

public class TemporarySong
extends SoundCommandSpecifier
implements Constants {
    private SongPattern[] pattern;

    public TemporarySong(BitInputStream bitInputStream) throws IOException {
        int n = bitInputStream.read();
        this.pattern = new SongPattern[n];
        for (int i = 0; i < this.pattern.length; ++i) {
            this.pattern[i] = new SongPattern(bitInputStream);
        }
    }

    public TemporarySong(SongPattern[] songPatternArray) {
        this.pattern = songPatternArray;
    }

    public int length() {
        int n = 11;
        for (int i = 0; i < this.pattern.length; ++i) {
            n += this.pattern[i].length();
        }
        return n;
    }

    public void writeToStream(BitOutputStream bitOutputStream) throws Exception {
        bitOutputStream.write(this.getType(), 3);
        bitOutputStream.write(this.pattern.length);
        for (int i = 0; i < this.pattern.length; ++i) {
            this.pattern[i].writeToStream(bitOutputStream);
        }
    }

    public int getType() {
        return 2;
    }

    public int getSongPatternLength() {
        return this.pattern.length;
    }

    public SongPattern getSongPattern(int n) {
        return this.pattern[n];
    }
}

